IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_NF_ENT_SEM_GERAR_FINANCEIRO]'))
DROP VIEW [dbo].[V_EST_NF_ENT_SEM_GERAR_FINANCEIRO]
GO
GO
--SELECT * FROM V_EST_NF_ENT_SEM_GERAR_FINANCEIRO
CREATE VIEW V_EST_NF_ENT_SEM_GERAR_FINANCEIRO AS
SELECT
    EST_NF_ENT.CD_EMP,
    EST_NF_ENT.CD_FILIAL,
    EST_NF_ENT.CD_NF,
    EST_NF_ENT.NR_NF,
    EST_NF_ENT.DT_EMI_NF,
    EST_NF_ENT.VLR_NF,
    EST_NF_ENT.CD_FORN,
    ISNULL(CANCEL.CD_EMP,0) AS NOTA_CANCEL_FINAN,
    ISNULL(EST_NF_ENT.IGNORAR_GERACAO_FINAN,0) AS IGNORAR_GERACAO_FINAN
FROM
    EST_NF_ENT INNER JOIN GLB_MOV_OP  ON
    EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
    LEFT OUTER JOIN EST_NF_ENT_FINANCEIRO_CANCEL CANCEL   ON
    CANCEL.CD_EMP=EST_NF_ENT.CD_EMP AND
    CANCEL.CD_FILIAL=EST_NF_ENT.CD_FILIAL AND        
    CANCEL.CD_NF=EST_NF_ENT.CD_NF
WHERE    
    GLB_MOV_OP.GERA_DP_PG = 1
    AND EST_NF_ENT.FLAG_NOTA_INTEGRACAO <> 1
    AND NOT EXISTS (SELECT
                        PG_CRED_EST_NF_ENT.CD_NF
                    FROM     
                        PG_CRED_EST_NF_ENT     INNER JOIN PG_CRED ON     
                        PG_CRED_EST_NF_ENT.CD_EMP = PG_CRED.CD_EMP AND    
                        PG_CRED_EST_NF_ENT.CD_FILIAL = PG_CRED.CD_FILIAL  AND    
                        PG_CRED_EST_NF_ENT.NR_DP = PG_CRED.NR_DP AND    
                        PG_CRED_EST_NF_ENT.ANO = PG_CRED.ANO
                    WHERE    
                        PG_CRED_EST_NF_ENT.CD_EMP = EST_NF_ENT.CD_EMP AND    
                        PG_CRED_EST_NF_ENT.CD_FILIAL = EST_NF_ENT.CD_FILIAL  AND    
                        PG_CRED_EST_NF_ENT.CD_NF = EST_NF_ENT.CD_NF    
                        AND PG_CRED.STS_DP <> 3)